/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.fml.util.DevEnvUtils;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;

public class UserdevLocator
implements IModFileCandidateLocator {
    private final Map<String, List<Path>> modFolders;

    public UserdevLocator(Map<String, List<Path>> modFolders) {
        this.modFolders = modFolders;
    }

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        HashSet claimed = this.modFolders.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(HashSet::new));
        for (List<Path> modFolderGroup : this.modFolders.values()) {
            pipeline.addPath(modFolderGroup, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.ERROR);
        }
        ArrayList<Path> fromClasspath = new ArrayList<Path>();
        fromClasspath.addAll(DevEnvUtils.findFileSystemRootsOfFileOnClasspath("META-INF/neoforge.mods.toml"));
        fromClasspath.addAll(DevEnvUtils.findFileSystemRootsOfFileOnClasspath("META-INF/MANIFEST.MF"));
        for (Path path : fromClasspath) {
            if (!claimed.add(path)) continue;
            pipeline.addPath(List.of(path), ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.WARN_ON_KNOWN_INCOMPATIBILITY);
        }
    }

    public String toString() {
        return "userdev mods and services";
    }

    @Override
    public int getPriority() {
        return -1000;
    }
}

