/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class Ingredient
implements Predicate<ItemStack> {
    public static final Ingredient EMPTY = new Ingredient(Stream.empty());
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = ItemStack.LIST_STREAM_CODEC.map(p_319730_ -> Ingredient.fromValues(p_319730_.stream().map(ItemValue::new)), p_319731_ -> Arrays.asList(p_319731_.getItems()));
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;
    public static final Codec<Ingredient> CODEC = Ingredient.codec(true);
    public static final Codec<Ingredient> CODEC_NONEMPTY = Ingredient.codec(false);

    private Ingredient(Stream<? extends Value> p_43907_) {
        this.values = (Value[])p_43907_.toArray(Value[]::new);
    }

    private Ingredient(Value[] p_301044_) {
        this.values = p_301044_;
    }

    public ItemStack[] getItems() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(p_43916_ -> p_43916_.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    @Override
    public boolean test(@Nullable ItemStack p_43914_) {
        if (p_43914_ == null) {
            return false;
        }
        if (this.isEmpty()) {
            return p_43914_.isEmpty();
        }
        for (ItemStack $$1 : this.getItems()) {
            if (!$$1.is(p_43914_.getItem())) continue;
            return true;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            ItemStack[] $$0 = this.getItems();
            this.stackingIds = new IntArrayList($$0.length);
            for (ItemStack $$1 : $$0) {
                this.stackingIds.add(StackedContents.getStackingIndex($$1));
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean equals(Object p_301003_) {
        if (p_301003_ instanceof Ingredient) {
            Ingredient $$1 = (Ingredient)p_301003_;
            return Arrays.equals(this.values, $$1.values);
        }
        return false;
    }

    private static Ingredient fromValues(Stream<? extends Value> p_43939_) {
        Ingredient $$1 = new Ingredient(p_43939_);
        return $$1.isEmpty() ? EMPTY : $$1;
    }

    public static Ingredient of() {
        return EMPTY;
    }

    public static Ingredient of(ItemLike ... p_43930_) {
        return Ingredient.of(Arrays.stream(p_43930_).map(ItemStack::new));
    }

    public static Ingredient of(ItemStack ... p_43928_) {
        return Ingredient.of(Arrays.stream(p_43928_));
    }

    public static Ingredient of(Stream<ItemStack> p_43922_) {
        return Ingredient.fromValues(p_43922_.filter(p_43944_ -> !p_43944_.isEmpty()).map(ItemValue::new));
    }

    public static Ingredient of(TagKey<Item> p_204133_) {
        return Ingredient.fromValues(Stream.of(new TagValue(p_204133_)));
    }

    private static Codec<Ingredient> codec(boolean p_301074_) {
        Codec $$1 = Codec.list(Value.CODEC).comapFlatMap(p_300810_ -> {
            if (!p_301074_ && p_300810_.size() < 1) {
                return DataResult.error(() -> "Item array cannot be empty, at least one item must be defined");
            }
            return DataResult.success((Object)p_300810_.toArray(new Value[0]));
        }, List::of);
        return Codec.either((Codec)$$1, Value.CODEC).flatComapMap(p_300805_ -> (Ingredient)p_300805_.map(Ingredient::new, p_300806_ -> new Ingredient(new Value[]{p_300806_})), p_300808_ -> {
            if (p_300808_.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)p_300808_.values[0]));
            }
            if (p_300808_.values.length == 0 && !p_301074_) {
                return DataResult.error(() -> "Item array cannot be empty, at least one item must be defined");
            }
            return DataResult.success((Object)Either.left((Object)p_300808_.values));
        });
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((ItemStack)object);
    }

    static interface Value {
        public static final Codec<Value> CODEC = Codec.xor(ItemValue.CODEC, TagValue.CODEC).xmap(p_300956_ -> (Value)p_300956_.map(p_300932_ -> p_300932_, p_301313_ -> p_301313_), p_301304_ -> {
            if (p_301304_ instanceof TagValue) {
                TagValue $$1 = (TagValue)p_301304_;
                return Either.right((Object)$$1);
            }
            if (p_301304_ instanceof ItemValue) {
                ItemValue $$2 = (ItemValue)p_301304_;
                return Either.left((Object)$$2);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> getItems();
    }

    record TagValue(TagKey<Item> tag) implements Value
    {
        static final Codec<TagValue> CODEC = RecordCodecBuilder.create(p_301118_ -> p_301118_.group((App)TagKey.codec(Registries.ITEM).fieldOf("tag").forGetter(p_301154_ -> p_301154_.tag)).apply((Applicative)p_301118_, TagValue::new));

        @Override
        public boolean equals(Object p_301162_) {
            if (p_301162_ instanceof TagValue) {
                TagValue $$1 = (TagValue)p_301162_;
                return $$1.tag.location().equals(this.tag.location());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList $$0 = Lists.newArrayList();
            for (Holder<Item> $$1 : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                $$0.add(new ItemStack($$1));
            }
            return $$0;
        }
    }

    record ItemValue(ItemStack item) implements Value
    {
        static final Codec<ItemValue> CODEC = RecordCodecBuilder.create(p_330109_ -> p_330109_.group((App)ItemStack.SIMPLE_ITEM_CODEC.fieldOf("item").forGetter(p_300919_ -> p_300919_.item)).apply((Applicative)p_330109_, ItemValue::new));

        @Override
        public boolean equals(Object p_301316_) {
            if (p_301316_ instanceof ItemValue) {
                ItemValue $$1 = (ItemValue)p_301316_;
                return $$1.item.getItem().equals(this.item.getItem()) && $$1.item.getCount() == this.item.getCount();
            }
            return false;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }
    }
}

