/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson gson;
    private final String directory;

    public SimpleJsonResourceReloadListener(Gson p_10768_, String p_10769_) {
        this.gson = p_10768_;
        this.directory = p_10769_;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager p_10771_, ProfilerFiller p_10772_) {
        HashMap<ResourceLocation, JsonElement> $$2 = new HashMap<ResourceLocation, JsonElement>();
        SimpleJsonResourceReloadListener.scanDirectory(p_10771_, this.directory, this.gson, $$2);
        return $$2;
    }

    public static void scanDirectory(ResourceManager p_279308_, String p_279131_, Gson p_279261_, Map<ResourceLocation, JsonElement> p_279404_) {
        FileToIdConverter $$4 = FileToIdConverter.json(p_279131_);
        for (Map.Entry<ResourceLocation, Resource> $$5 : $$4.listMatchingResources(p_279308_).entrySet()) {
            ResourceLocation $$6 = $$5.getKey();
            ResourceLocation $$7 = $$4.fileToId($$6);
            try {
                BufferedReader $$8 = $$5.getValue().openAsReader();
                try {
                    JsonElement $$9 = GsonHelper.fromJson(p_279261_, (Reader)$$8, JsonElement.class);
                    JsonElement $$10 = p_279404_.put($$7, $$9);
                    if ($$10 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf($$7));
                }
                finally {
                    if ($$8 == null) continue;
                    ((Reader)$$8).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException $$11) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{$$7, $$6, $$11});
            }
        }
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }
}

