/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.StitcherException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class Stitcher<T extends Entry> {
    private static final Comparator<Holder<?>> HOLDER_COMPARATOR = Comparator.comparing(p_118201_ -> -p_118201_.height).thenComparing(p_118199_ -> -p_118199_.width).thenComparing(p_247945_ -> p_247945_.entry.name());
    private final int mipLevel;
    private final List<Holder<T>> texturesToBeStitched = new ArrayList<Holder<T>>();
    private final List<Region<T>> storage = new ArrayList<Region<T>>();
    private int storageX;
    private int storageY;
    private final int maxWidth;
    private final int maxHeight;

    public Stitcher(int p_118171_, int p_118172_, int p_118173_) {
        this.mipLevel = p_118173_;
        this.maxWidth = p_118171_;
        this.maxHeight = p_118172_;
    }

    public int getWidth() {
        return this.storageX;
    }

    public int getHeight() {
        return this.storageY;
    }

    public void registerSprite(T p_249253_) {
        Holder<T> $$1 = new Holder<T>(p_249253_, this.mipLevel);
        this.texturesToBeStitched.add($$1);
    }

    public void stitch() {
        ArrayList<Holder<T>> $$0 = new ArrayList<Holder<T>>(this.texturesToBeStitched);
        $$0.sort(HOLDER_COMPARATOR);
        for (Holder holder : $$0) {
            if (this.addToStorage(holder)) continue;
            throw new StitcherException((Entry)holder.entry, (Collection)$$0.stream().map(p_247946_ -> p_247946_.entry).collect(ImmutableList.toImmutableList()));
        }
    }

    public void gatherSprites(SpriteLoader<T> p_118181_) {
        for (Region<T> $$1 : this.storage) {
            $$1.walk(p_118181_);
        }
    }

    static int smallestFittingMinTexel(int p_118189_, int p_118190_) {
        return (p_118189_ >> p_118190_) + ((p_118189_ & (1 << p_118190_) - 1) == 0 ? 0 : 1) << p_118190_;
    }

    private boolean addToStorage(Holder<T> p_118179_) {
        for (Region<T> $$1 : this.storage) {
            if (!$$1.add(p_118179_)) continue;
            return true;
        }
        return this.expand(p_118179_);
    }

    private boolean expand(Holder<T> p_118192_) {
        Region<T> $$12;
        boolean $$10;
        boolean $$8;
        boolean $$6;
        int $$1 = Mth.smallestEncompassingPowerOfTwo(this.storageX);
        int $$2 = Mth.smallestEncompassingPowerOfTwo(this.storageY);
        int $$3 = Mth.smallestEncompassingPowerOfTwo(this.storageX + p_118192_.width);
        int $$4 = Mth.smallestEncompassingPowerOfTwo(this.storageY + p_118192_.height);
        boolean $$5 = $$3 <= this.maxWidth;
        boolean bl = $$6 = $$4 <= this.maxHeight;
        if (!$$5 && !$$6) {
            return false;
        }
        boolean $$7 = $$5 && $$1 != $$3;
        boolean bl2 = $$8 = $$6 && $$2 != $$4;
        if ($$7 ^ $$8) {
            boolean $$9 = $$7;
        } else {
            boolean bl3 = $$10 = $$5 && $$1 <= $$2;
        }
        if ($$10) {
            if (this.storageY == 0) {
                this.storageY = $$4;
            }
            Region $$11 = new Region(this.storageX, 0, $$3 - this.storageX, this.storageY);
            this.storageX = $$3;
        } else {
            $$12 = new Region<T>(0, this.storageY, this.storageX, $$4 - this.storageY);
            this.storageY = $$4;
        }
        $$12.add(p_118192_);
        this.storage.add($$12);
        return true;
    }

    record Holder<T extends Entry>(T entry, int width, int height) {
        public Holder(T p_250261_, int p_250127_) {
            this(p_250261_, Stitcher.smallestFittingMinTexel(p_250261_.width(), p_250127_), Stitcher.smallestFittingMinTexel(p_250261_.height(), p_250127_));
        }
    }

    public static interface Entry {
        public int width();

        public int height();

        public ResourceLocation name();
    }

    public static class Region<T extends Entry> {
        private final int originX;
        private final int originY;
        private final int width;
        private final int height;
        @Nullable
        private List<Region<T>> subSlots;
        @Nullable
        private Holder<T> holder;

        public Region(int p_118216_, int p_118217_, int p_118218_, int p_118219_) {
            this.originX = p_118216_;
            this.originY = p_118217_;
            this.width = p_118218_;
            this.height = p_118219_;
        }

        public int getX() {
            return this.originX;
        }

        public int getY() {
            return this.originY;
        }

        public boolean add(Holder<T> p_118222_) {
            if (this.holder != null) {
                return false;
            }
            int $$1 = p_118222_.width;
            int $$2 = p_118222_.height;
            if ($$1 > this.width || $$2 > this.height) {
                return false;
            }
            if ($$1 == this.width && $$2 == this.height) {
                this.holder = p_118222_;
                return true;
            }
            if (this.subSlots == null) {
                this.subSlots = new ArrayList<Region<T>>(1);
                this.subSlots.add(new Region<T>(this.originX, this.originY, $$1, $$2));
                int $$3 = this.width - $$1;
                int $$4 = this.height - $$2;
                if ($$4 > 0 && $$3 > 0) {
                    int $$6;
                    int $$5 = Math.max(this.height, $$3);
                    if ($$5 >= ($$6 = Math.max(this.width, $$4))) {
                        this.subSlots.add(new Region<T>(this.originX, this.originY + $$2, $$1, $$4));
                        this.subSlots.add(new Region<T>(this.originX + $$1, this.originY, $$3, this.height));
                    } else {
                        this.subSlots.add(new Region<T>(this.originX + $$1, this.originY, $$3, $$2));
                        this.subSlots.add(new Region<T>(this.originX, this.originY + $$2, this.width, $$4));
                    }
                } else if ($$3 == 0) {
                    this.subSlots.add(new Region<T>(this.originX, this.originY + $$2, $$1, $$4));
                } else if ($$4 == 0) {
                    this.subSlots.add(new Region<T>(this.originX + $$1, this.originY, $$3, $$2));
                }
            }
            for (Region<T> $$7 : this.subSlots) {
                if (!$$7.add(p_118222_)) continue;
                return true;
            }
            return false;
        }

        public void walk(SpriteLoader<T> p_250195_) {
            if (this.holder != null) {
                p_250195_.load(this.holder.entry, this.getX(), this.getY());
            } else if (this.subSlots != null) {
                for (Region $$1 : this.subSlots) {
                    $$1.walk(p_250195_);
                }
            }
        }

        public String toString() {
            return "Slot{originX=" + this.originX + ", originY=" + this.originY + ", width=" + this.width + ", height=" + this.height + ", texture=" + String.valueOf(this.holder) + ", subSlots=" + String.valueOf(this.subSlots) + "}";
        }
    }

    public static interface SpriteLoader<T extends Entry> {
        public void load(T var1, int var2, int var3);
    }
}

