/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;

public class BedRenderer
implements BlockEntityRenderer<BedBlockEntity> {
    private final ModelPart headRoot;
    private final ModelPart footRoot;

    public BedRenderer(BlockEntityRendererProvider.Context p_173540_) {
        this.headRoot = p_173540_.bakeLayer(ModelLayers.BED_HEAD);
        this.footRoot = p_173540_.bakeLayer(ModelLayers.BED_FOOT);
    }

    public static LayerDefinition createHeadLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f), PartPose.ZERO);
        $$1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 6).addBox(0.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, 1.5707964f));
        $$1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(50, 18).addBox(-16.0f, 6.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, (float)Math.PI));
        return LayerDefinition.create($$0, 64, 64);
    }

    public static LayerDefinition createFootLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("main", CubeListBuilder.create().texOffs(0, 22).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f), PartPose.ZERO);
        $$1.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 0).addBox(0.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, 0.0f));
        $$1.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(50, 12).addBox(-16.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.rotation(1.5707964f, 0.0f, 4.712389f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public void render(BedBlockEntity p_112205_, float p_112206_, PoseStack p_112207_, MultiBufferSource p_112208_, int p_112209_, int p_112210_) {
        Material $$6 = Sheets.BED_TEXTURES[p_112205_.getColor().getId()];
        Level $$7 = p_112205_.getLevel();
        if ($$7 != null) {
            BlockState $$8 = p_112205_.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult<BedBlockEntity> $$9 = DoubleBlockCombiner.combineWithNeigbour(BlockEntityType.BED, BedBlock::getBlockType, BedBlock::getConnectedDirection, ChestBlock.FACING, $$8, $$7, p_112205_.getBlockPos(), (p_112202_, p_112203_) -> false);
            int $$10 = ((Int2IntFunction)$$9.apply(new BrightnessCombiner())).get(p_112209_);
            this.renderPiece(p_112207_, p_112208_, $$8.getValue(BedBlock.PART) == BedPart.HEAD ? this.headRoot : this.footRoot, $$8.getValue(BedBlock.FACING), $$6, $$10, p_112210_, false);
        } else {
            this.renderPiece(p_112207_, p_112208_, this.headRoot, Direction.SOUTH, $$6, p_112209_, p_112210_, false);
            this.renderPiece(p_112207_, p_112208_, this.footRoot, Direction.SOUTH, $$6, p_112209_, p_112210_, true);
        }
    }

    private void renderPiece(PoseStack p_173542_, MultiBufferSource p_173543_, ModelPart p_173544_, Direction p_173545_, Material p_173546_, int p_173547_, int p_173548_, boolean p_173549_) {
        p_173542_.pushPose();
        p_173542_.translate(0.0f, 0.5625f, p_173549_ ? -1.0f : 0.0f);
        p_173542_.mulPose(Axis.XP.rotationDegrees(90.0f));
        p_173542_.translate(0.5f, 0.5f, 0.5f);
        p_173542_.mulPose(Axis.ZP.rotationDegrees(180.0f + p_173545_.toYRot()));
        p_173542_.translate(-0.5f, -0.5f, -0.5f);
        VertexConsumer $$8 = p_173546_.buffer(p_173543_, RenderType::entitySolid);
        p_173544_.render(p_173542_, $$8, p_173547_, p_173548_);
        p_173542_.popPose();
    }
}

