/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class VibrationSignalParticle
extends TextureSheetParticle {
    private final PositionSource target;
    private float rot;
    private float rotO;
    private float pitch;
    private float pitchO;

    VibrationSignalParticle(ClientLevel p_234105_, double p_234106_, double p_234107_, double p_234108_, PositionSource p_234109_, int p_234110_) {
        super(p_234105_, p_234106_, p_234107_, p_234108_, 0.0, 0.0, 0.0);
        this.quadSize = 0.3f;
        this.target = p_234109_;
        this.lifetime = p_234110_;
        Optional<Vec3> $$6 = p_234109_.getPosition(p_234105_);
        if ($$6.isPresent()) {
            Vec3 $$7 = $$6.get();
            double $$8 = p_234106_ - $$7.x();
            double $$9 = p_234107_ - $$7.y();
            double $$10 = p_234108_ - $$7.z();
            this.rotO = this.rot = (float)Mth.atan2($$8, $$10);
            this.pitchO = this.pitch = (float)Mth.atan2($$9, Math.sqrt($$8 * $$8 + $$10 * $$10));
        }
    }

    @Override
    public void render(VertexConsumer p_172475_, Camera p_172476_, float p_172477_) {
        float $$3 = Mth.sin(((float)this.age + p_172477_ - (float)Math.PI * 2) * 0.05f) * 2.0f;
        float $$4 = Mth.lerp(p_172477_, this.rotO, this.rot);
        float $$5 = Mth.lerp(p_172477_, this.pitchO, this.pitch) + 1.5707964f;
        Quaternionf $$6 = new Quaternionf();
        $$6.rotationY($$4).rotateX(-$$5).rotateY($$3);
        this.renderRotatedQuad(p_172475_, p_172476_, $$6, p_172477_);
        $$6.rotationY((float)(-Math.PI) + $$4).rotateX($$5).rotateY($$3);
        this.renderRotatedQuad(p_172475_, p_172476_, $$6, p_172477_);
    }

    @Override
    public int getLightColor(float p_172469_) {
        return 240;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        Optional<Vec3> $$0 = this.target.getPosition(this.level);
        if ($$0.isEmpty()) {
            this.remove();
            return;
        }
        int $$1 = this.lifetime - this.age;
        double $$2 = 1.0 / (double)$$1;
        Vec3 $$3 = $$0.get();
        this.x = Mth.lerp($$2, this.x, $$3.x());
        this.y = Mth.lerp($$2, this.y, $$3.y());
        this.z = Mth.lerp($$2, this.z, $$3.z());
        double $$4 = this.x - $$3.x();
        double $$5 = this.y - $$3.y();
        double $$6 = this.z - $$3.z();
        this.rotO = this.rot;
        this.rot = (float)Mth.atan2($$4, $$6);
        this.pitchO = this.pitch;
        this.pitch = (float)Mth.atan2($$5, Math.sqrt($$4 * $$4 + $$6 * $$6));
    }

    public static class Provider
    implements ParticleProvider<VibrationParticleOption> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_172490_) {
            this.sprite = p_172490_;
        }

        @Override
        public Particle createParticle(VibrationParticleOption p_172501_, ClientLevel p_172502_, double p_172503_, double p_172504_, double p_172505_, double p_172506_, double p_172507_, double p_172508_) {
            VibrationSignalParticle $$8 = new VibrationSignalParticle(p_172502_, p_172503_, p_172504_, p_172505_, p_172501_.getDestination(), p_172501_.getArrivalInTicks());
            $$8.pickSprite(this.sprite);
            $$8.setAlpha(1.0f);
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((VibrationParticleOption)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }
}

