/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.cl;

import cpw.mods.cl.UnionURLStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class ModularURLHandler
implements URLStreamHandlerFactory {
    public static final ModularURLHandler INSTANCE = new ModularURLHandler();
    private Map<String, IURLProvider> handlers;

    public static void initFrom(@Nullable ModuleLayer layer) {
        HashMap<String, UnionURLStreamHandler> handlers = new HashMap<String, UnionURLStreamHandler>();
        UnionURLStreamHandler unionHandler = new UnionURLStreamHandler();
        handlers.put(unionHandler.protocol(), unionHandler);
        if (layer == null) {
            ServiceLoader.load(IURLProvider.class).stream().map(ServiceLoader.Provider::get).forEach(handler -> handlers.putIfAbsent(handler.protocol(), (UnionURLStreamHandler)handler));
        } else {
            ServiceLoader.load(layer, IURLProvider.class).stream().map(ServiceLoader.Provider::get).forEach(handler -> handlers.putIfAbsent(handler.protocol(), (UnionURLStreamHandler)handler));
        }
        ModularURLHandler.INSTANCE.handlers = Map.copyOf(handlers);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.handlers == null) {
            return null;
        }
        if (this.handlers.containsKey(protocol)) {
            return new FunctionURLStreamHandler(this.handlers.get(protocol));
        }
        return null;
    }

    public static interface IURLProvider {
        public String protocol();

        public Function<URL, InputStream> inputStreamFunction();

        default public long getLastModified(URL url) {
            return 0L;
        }

        default public long getContentLength(URL url) {
            return -1L;
        }
    }

    private static class FunctionURLStreamHandler
    extends URLStreamHandler {
        private final IURLProvider iurlProvider;

        public FunctionURLStreamHandler(IURLProvider iurlProvider) {
            this.iurlProvider = iurlProvider;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new FunctionURLConnection(u, this.iurlProvider);
        }
    }

    private static class FunctionURLConnection
    extends URLConnection {
        private final IURLProvider provider;

        protected FunctionURLConnection(URL url, IURLProvider provider) {
            super(url);
            this.provider = provider;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return this.provider.inputStreamFunction().apply(this.url);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public int getContentLength() {
            long length = this.getContentLengthLong();
            if (length < 0L || length > Integer.MAX_VALUE) {
                return -1;
            }
            return (int)length;
        }

        @Override
        public long getContentLengthLong() {
            return this.provider.getContentLength(this.url);
        }

        @Override
        public long getLastModified() {
            return this.provider.getLastModified(this.url);
        }
    }
}

